<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('fullname', 'country_id', 'city_id', 'language', 'mobile', 'mobile_code', 'verification_code', 'email', 'password', 'type', 'wallet', 'image', 'wallet_used', 'sound', 'viberation', 'verification_status', 'personal_gift', 'personal_gift_status', 'id_number', 'lat', 'lng', 'online', 'lower_class');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function tokens()
    {
        return $this->hasMany('Token', 'user_id');
    }

}